/******************************************************************************/
class SetBool : BaseEvent
{
public:
            SetBool();
   virtual ~SetBool();
   
   virtual void create(Object &obj); 
   virtual void AfterCreate(      );
   
private:

   virtual void CallTriggeredAction();
   virtual void StopTriggeredAction();
   
   UID m_BoolUID;
   VarBool* m_VarBool;
   bool m_Value, m_OrigValue;
};
/******************************************************************************/
SetBool::SetBool() : BaseEvent(), m_Value(false), m_OrigValue(false), m_VarBool(null)                     
{
   
}
SetBool::~SetBool()
{
   
}
/******************************************************************************/
void SetBool::create(Object &obj)
{
   // Getting the parameters from the object in the world
   if(Param *p = obj.findParam("VarBoolUID")) m_BoolUID = p.asID();
   if(Param *p = obj.findParam("Value"))      m_Value   = p.asBool();
   
   m_OrigValue = m_Value;
   
   super.create(obj); // Create the BaseEvent params too
}
/******************************************************************************/
void SetBool::AfterCreate()
{
   // Find the correct VarInt to work on. This has to be done here, because it's unreliable during create() (not all objects are loaded yet)
   REPA(variablesBool)
      if(variablesBool[i].id() == m_BoolUID)
         m_VarBool = &variablesBool[i]; 
         
   DEBUG_ASSERT(m_VarBool, "VarBool not found in scene");
}
/******************************************************************************/
// This method is called when the event was triggered, taking the delay into account
void SetBool::CallTriggeredAction()
{
   if(m_LogDetailed || m_LogOutput)
   {
      LogN(S+"Start Trigger: Setting VarBool (INFO: " + m_EditorInfo + " ) from: " + m_VarBool->GetValue() + ", to: " + m_Value);
   }
   
   m_VarBool->SetValue(m_Value);
}

// This method is called when the duration of the event has been reached
void SetBool::StopTriggeredAction()
{
   if(m_LogDetailed || m_LogOutput)
   {
      LogN(S+" Stop Trigger: Setting VarBool (INFO: " + m_EditorInfo + " ) from: " + m_VarBool->GetValue() + ", to: " + m_OrigValue);
   }
   
   // If m_Duration is not -1, the bool will be set back to its original value, after a while
   m_VarBool->SetValue(m_OrigValue); 
}
/******************************************************************************/